/*
 * com_cl.c
 *
 * COMDLL interface layer for CLSER frame grabbers
 * 
 * $Id: comdll_fg.c,v 1.3 2008-03-06 12:13:07 hofmann Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>

#include "comdll_fg.h"
#include "clser.h"


// Enable debug output
//#define debug

#define DELAY  10000	// us


#define socket_name "/tmp/pfcomserver.socket"

DWORD clSerialRead_FG(HANDLE sock, BYTE *buff, DWORD *dwLength, DWORD time_max)
{
	int res;
	DWORD size = *dwLength;
	DWORD magick = size;
	

//	printf("read: %li\n", size);

	res = write(sock, &magick, 4);
	if (res != 4) {
	    fprintf(stderr, "Write of magic is failed (%i of 4), error: %i\n", res, errno);
	    return CL_ERR_TIMEOUT;	
	}
	
	res = read(sock, &magick, 4);
	if (res != 4) {
	    fprintf(stderr, "Read of magic is failed (%i of 4), error: %i\n", res, errno);
	    return CL_ERR_TIMEOUT;	
	}
	
	if (magick) {
		// Thats fine and could happen
#ifdef debug
	    fprintf(stderr, "Error returned by the server\n");
#endif
	    return CL_ERR_TIMEOUT;	
	}


	res = read(sock, buff, size);
	if (res != size) {
	    fprintf(stderr, "Read failed (%i of %li), error: %i\n", res, size, errno);
	    return CL_ERR_TIMEOUT;
	}
	
//	puts("done");
	
	return CL_ERR_NO_ERR;
}

DWORD clSerialWrite_FG(HANDLE sock, BYTE *buff, DWORD *dwLength, DWORD time_max)
{
	int res;	
	int size = *dwLength;
	DWORD magick = 0;
	
//	printf("write: %i\n", size);

	res = write(sock, &magick, 4);
	if (res != 4) {
	    fprintf(stderr, "Write failed (%i of 4), error: %i\n", res, errno);
	    return CL_ERR_TIMEOUT;	
	}
	
	usleep(DELAY);

	res = write(sock, buff, size);
	if (res != size) {
	    fprintf(stderr, "Write failed (%i of %i), error: %i\n", res, size, errno);
	    return CL_ERR_TIMEOUT;	
	}
	
	usleep(DELAY);
	
//	puts("done");
	
	return CL_ERR_NO_ERR;
}

int clSerialInit_FG(int serialIndex, HANDLE *h)
{

#ifdef debug
        printf("clSerialInit_FG()\n");
#endif

	struct sockaddr_un servername;
	int sock;
	
	sock = socket (PF_UNIX, SOCK_STREAM, 0);
	if (sock < 0) {
		fprintf(stderr, "Failed to create socket, error: %i\n", errno);
		return CL_ERR_TIMEOUT;
	}

	memset(&servername, 0, sizeof(servername));
	servername.sun_family = AF_UNIX;
	strncpy(servername.sun_path,socket_name,sizeof(servername.sun_path));
	servername.sun_path[sizeof(servername.sun_path) - 1]=0;

	if (connect (sock, (struct sockaddr *) &servername, sizeof (servername)) < 0){
		fprintf(stderr, "Connection to socket is failed, error: %i\n", errno);
		return CL_ERR_ERROR_NOT_FOUND;
	}

        *h = sock;

        return CL_ERR_NO_ERR;
}

int clSerialClose_FG(HANDLE h) {
    if (h >= 0) close(h);

    return 1; 
}
