#ifndef _CL_H
#define _CL_H

typedef int (*TCameraFrameCallback)(void *ctx, int frame_id, void *data); 
typedef enum TCameraLinkFlags {
    CL_FLAGS_SECURE = 1
} CameraLinkFlags;


struct TCameraLink {
    int running;
    int max_width, max_height;
    int width, height;
    
    void *fg;

    TCameraFrameCallback cb;
    void *cbctx;
    
//    frameindex_t current_frame;
//    frameindex_t last_frame;
};

typedef struct TCameraLink CameraLink;


CameraLink *cl_create();
int cl_init(CameraLink *ctx);
void cl_free(CameraLink *ctx);
void cl_destroy(CameraLink *ctx);

int cl_set_max_resolution(CameraLink *ctx, int width, int height);
int cl_register_frame_callback(CameraLink *ctx, TCameraFrameCallback callback, void *data);

int cl_open(CameraLink *ctx, int width, int height, int flags);
int cl_close(CameraLink *ctx);

int cl_set_resolution(CameraLink *ctx, int width, int height);
int cl_run_frames_continuous(CameraLink *ctx, int *run_flag, TCameraFrameCallback callback, void *cbctx);


#endif /* _CL_H */
