unsigned short int nch; 	// Number of channels
unsigned short int nbar;	// Barometer channel
unsigned short int tint;	// Interval time ( in seconds )
unsigned short int tfint;	// Write file interval ( in records )
char iname[32];
char wrpath[255];

int ReadConfig(FILE *f)
{
    unsigned long err;
    if (err=SkipComments(f,0)) return err;
    fscanf(f,"%u",&nch);
    if (err=SkipComments(f,1)) return err;
    fscanf(f,"%u",&nbar);
    if (err=SkipComments(f,1)) return err;
    fscanf(f,"%u",&tint);
    if (err=SkipComments(f,1)) return err;
    fscanf(f,"%u",&tfint);
    if (err=SkipComments(f,1)) return err;
    fscanf(f,"%31s",iname);
    if (err=SkipComments(f,1)) return err;
    fscanf(f,"%254s",wrpath);
}

    // Configuration
void Setup()
{
    FILE *f=fopen("nm.dat", "r");
    if (!f) f = fopen("/etc/nm.dat", "r");
    if (!f) {
	printf("Can't open configuration file (/etc/nm.dat)!\nExiting.\n");
	exit(1);
    }
    ReadConfig(f);
    fclose(f);
    printf("\nDefault Setup:\nNumber of chanels   = %u\nBarometer channel   = %u\n",nch,nbar);
    printf("Interval time       = %u sec\nWrite file interval = %u records\n",tint,tfint);
    if (tfint>10) tfint=10;
}    
