#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

#include "display.h"

#define clyport 13002
#define port 13001
#define Server "127.0.0.1"
#define ReAnnounceTimeout 3000
#define Timeout 600

main(int argc, char *argv[])
{
    int err;
    int cport;
    int dsock;
    struct sockaddr_in servaddr, clientaddr;
    int clientaddrsize=sizeof(struct sockaddr_in);
    unsigned char idmsg[5];
    unsigned short int buf[256];
    time_t LastPacketTime,LastAnnounceTime,CurTime;

    dsock=socket(PF_INET,SOCK_DGRAM,IPPROTO_UDP);
    if (dsock<0)
    {
	fprintf(stderr,"Can't open socket!");
	exit(1);
    }
    
	// Configuring server port ( Parsing configuration )
    servaddr.sin_family=AF_INET;
    servaddr.sin_port=htons(clyport);
    servaddr.sin_addr.s_addr=htonl(INADDR_ANY);

    if (bind(dsock,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in))) {
	cport = clyport; err = 1;
	while ((err)&&(errno==EADDRINUSE)&&(cport<clyport+100)) {
	    servaddr.sin_port=htons(++cport);
	    err = bind(dsock,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in));
	}
	if (err) {    
	    fprintf(stderr, "Can't bind socket on port %lu\n",clyport);
	    exit(1);
	}
    }

	// Configuring server port ( Parsing configuration )
    servaddr.sin_family=AF_INET;
    servaddr.sin_port=htons(port);
    
    if (argc>1) {
	printf("Connecting: %s\n",argv[1]);
	servaddr.sin_addr.s_addr=inet_addr(argv[1]);
    } else {
	printf("Connecting: %s\n",Server);
	servaddr.sin_addr.s_addr=inet_addr(Server);
    }

    idmsg[0]=0xD0;	// New client arrived message

    err=sendto(dsock,idmsg,1,0,(struct sockaddr*)&servaddr,
		sizeof(struct sockaddr_in));
    
    LastPacketTime=time(NULL);
    LastAnnounceTime=LastPacketTime;
    while (1)
    {
	err=recvfrom(dsock,(void*)buf,256,0,
    	    (struct sockaddr*)&clientaddr,&clientaddrsize);
	
	if ((err>0)&&(buf[0]==0xD1))
	{
	    LastPacketTime=time(NULL);
	    Display(buf+1);
	}
	CurTime=time(NULL);
	if ((CurTime-LastPacketTime>Timeout)||
	    (CurTime-LastAnnounceTime>ReAnnounceTimeout))
	{
	    err=sendto(dsock,idmsg,1,0,(struct sockaddr*)&servaddr,
		    sizeof(struct sockaddr_in));
	    LastAnnounceTime=CurTime;
	}
    }
}
