%define name bsdftpd-6.0-ssl
%define version 0.6.3

Name: %{name}
Version: %{version}
Release: csa16
Summary: Secure FTP daemon for FreeBSD and Linux.
Copyright: BSD
Group:		System/Servers
Distribution:	DarkLin
Vendor:		DarkSoft
Packager:	Kain <ds7fff@myrealbox.com>
Prefix: 	%{_prefix}
Source0: %{name}-%{version}.tar.bz2
Source1: bsdftpd.xinetd
Source2: ftpd.initd
Source3: x509.users
Source4: auth.sslftp
Source5: ftpd.sysconfig
Source6: ftpd.pam
Patch : bsdftpd-6.0-ssl-0.5.4-megaloman.patch
Patch1: bsdftpd-ds-keypassword.patch.bz2
Patch2: bsdftpd-ds-extprog.patch.bz2
Patch3: bsdftpd-ds-anonymous.patch.bz2
Patch4: bsdftpd-ds-pport.patch.bz2
BuildRoot: %{_tmppath}/%{name}-root
BuildRequires: openssl-devel
BuildRequires: libtermcap-devel
BuildRequires: byacc
Requires: /usr/bin/perl

%description
Bsdftpd-ssl is an RFC2228 "FTP Security Extensions"-compliant FTP server. It
is based on FreeBSD ftpd, so it seems to be a stable and secure solution for
authorized user access. It is also supports TLS/SSL for both control and
data connections. This feature requires special clients that are also
available. Both server and clients are fully compatible with standard FTP
protocol (for example, FTP server can support TLS/SSL and standard clients
simultaneously).

%package -n bsdftpclient-ssl
Summary: Secure FTP client for FreeBSD and Linux.
Group: Applications/Internet

%description -n bsdftpclient-ssl
Bsdftpclient-ssl is an FTP client. It is based on FreeBSD ftp utility,
so it seems to be a stable and secure solution for authorized user access.
It is also supports TLS/SSL for both control and data connections.
This feature requires special servers that are also available. Both server
and clients are fully compatible with standard FTP protocol (for example,
FTP server can support TLS/SSL and standard clients simultaneously).

%prep
%setup -n bsdftpd-6.0-ssl-%{version}
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
## %patch -p1

%build
./config.sh Linux
export RPM_OPT_FLAGS="$RPM_OPT_FLAGS"
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT{%{_bindir},%{_sbindir}}
mkdir -p $RPM_BUILD_ROOT/usr/share
mkdir -p $RPM_BUILD_ROOT/usr/man/{man1,man3,man5,man8}
mkdir -p $RPM_BUILD_ROOT/etc/xinetd.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
%makeinstall INSTALLTOP="$RPM_BUILD_ROOT%{_prefix}"
%{__install} -m 0644 %{SOURCE1} $RPM_BUILD_ROOT/etc/xinetd.d/bsdftpd
%{__install} -m 0755 %{SOURCE2} $RPM_BUILD_ROOT/etc/rc.d/init.d/ftpd
%{__install} -m 0755 %{SOURCE5} $RPM_BUILD_ROOT/etc/sysconfig/ftpd
%{__install} -m 0644 %{SOURCE6} $RPM_BUILD_ROOT/etc/pam.d/ftpd
mv $RPM_BUILD_ROOT/usr/man $RPM_BUILD_ROOT/usr/share/
%{__install} -m 0644 %{SOURCE3} $RPM_BUILD_ROOT/etc
%{__install} -m 0755 %{SOURCE4} $RPM_BUILD_ROOT/usr/bin

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ $1 = 1 ]; then 
    if [ -f %{_sysconfdir}/rc.d/init.d/ftpd ]; then
	 %{_sysconfdir}/rc.d/init.d/ftpd start
    fi
    chkconfig --add ftpd
    chkconfig ftpd on
else
    if [ -f %{_sysconfdir}/rc.d/init.d/ftpd ]; then
	 %{_sysconfdir}/rc.d/init.d/ftpd restart
    fi
fi

%preun
if [ $1 = 0 ]; then 
    if [ -f %{_sysconfdir}/rc.d/init.d/ftpd ]; then
	 %{_sysconfdir}/rc.d/init.d/ftpd stop
    fi
    chkconfig --del ftpd
fi

%files
%defattr(-,root,root)
%doc ChangeLog INSTALL README cert docs
%attr(0555,root,root) %{_sbindir}/ftpd
%{_mandir}/man8/
#%config(noreplace) /etc/xinetd.d/bsdftpd
/etc/rc.d/init.d/ftpd
%config /etc/pam.d/ftpd
%config(noreplace) /etc/x509.users 
%config(noreplace) /etc/sysconfig/ftpd
%attr(0644,root,root) %{_bindir}/auth.sslftp

%files -n bsdftpclient-ssl
%attr(0555,root,root) %{_bindir}/ftps
%{_mandir}/man1/
%{_mandir}/man3/
%{_mandir}/man5/
